#!/bin/bash
#To start, put a symbolic link of cns 1.2 in the main directory.

cns='cns' #name of symbolic link

#preparing structure and restraints
#1 - the "subunits" folder contains initial pdb files
#2 - the "domains_definition" folder contains cns input needed to define the chains and insertions
#3 - cross-links restraints are assumed to be already in the "restraints" folder




	# generate topology
	$cns < 01.make_psf.inp > log/01.make_psf.out
    # generate sequential restraints
	$cns < 02.make_chainrestraints.inp > log/02.make_chainrestraints.out
	# generate elastic network restraints (can last a few minutes)
	$cns < 03.make_restraints.inp > log/03.make_restraints.out
	# generate lysine restraints
	$cns < 04.make_lys_restraints.inp > log/04.make_lys_restraints.out

#runing docking simulation

	$cns < scripts/10.simulation.inp > log/10.simulation.out

#
#
#
#
#
#
